//this mutator allows for custom quests, for rpg server fun.
class QuestMutator expands Mutator;

struct sQuests
{
var() string QuestName;
var() string GiveQuestMessage;
var() bool bGiveMessageOnHUD;
var() string CompleteQuestMessage;
var() bool bCompleteMessageOnHUD;var() Actor ClassesToReplace[10];
var() string ReplacementClassNames[10];
var() bool bTrackReplacedClasses;
var() int QuestTrackingReplaced;
var() String NewReplacementClasses[10];
var() string CompletedMessageToBroadcast;
var() bool BroadcastUponCompletion;
var() name CompletedEvent;
var() string PlayerCompletedNames[50];
var() int CompletedQuestNeeded;
var() bool bNeedCompletedQuest;
var() bool bGiveReward;
var() string QuestReward;
var() vector RewardLocation;
var() bool bGiveRewardToPlayer;
var() string RewardProp1, RewardProp2, RewardProp3, RewardProp4;
var() string PropValue1, PropValue2, PropValue3, PropValue4;
var() int CashReward, BreadReward, ChocolateReward, FruitReward, SoyReward, SpicesReward, SugarReward;
var() bool bQuestAvailable;
var() bool bDisableQuestAfterCompletion;
var() int QuestToEnable;
var() bool bEnablesNewQuest;
};

var() string NotAvailableMessage;
var() string AlreadyCompletedMessage;
var() string QuestDisabledMessage;
var() sQuests AvailableQuests[20];
var() int TeamsNeededForQuests[20];
var() int MetalsRewards[20];
var() string NoRewardMessage;

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

function bool IsValidQuest(string QuestToLookFor)
{
 local int j;

      for (j=0; j<ArrayCount(AvailableQuests); j++)
      {
	if (AvailableQuests[j].QuestName ~= QuestToLookFor)
         return true;
      }
 return false;
}

function int GetQuestNum(string QuestToLookFor)
{
 local int j;

      for (j=0; j<ArrayCount(AvailableQuests); j++)
      {
	if (AvailableQuests[j].QuestName ~= QuestToLookFor)
         return j;
      }
 return -1;
}

function CompleteQuest(String CompletedQuest, MSMTLPlayer Player)
{
local int i;
local actor Replaced;
local Class<actor> RewardClass;
local Actor Reward;
local HUDMissionStartTextDisplay HUD;
local Actor A;
local class<Actor> aClass;
local int CurReplaceNum;

  //are we a valid quest?
 if (IsValidQuest(CompletedQuest))
 {
  //get the quest number
  i = GetQuestNum(CompletedQuest);

 if (AvailableQuests[i].bGiveReward)
 { 
  //give the player their rewards
  Player.Credits += AvailableQuests[i].CashReward;
  Player.Bread += AvailableQuests[i].BreadReward;
  Player.Fruit += AvailableQuests[i].FruitReward;
  Player.Chocolate += AvailableQuests[i].ChocolateReward;
  Player.Soy += AvailableQuests[i].SoyReward;
  Player.Sugar += AvailableQuests[i].SugarReward;
  Player.Spices += AvailableQuests[i].SpicesReward;
  Player.Metals += MetalsRewards[i]; //added late, noticed i forgot it.   

  //if we spawn this at a location
  if (!AvailableQuests[i].bGiveRewardToPlayer)
  {
   	RewardClass = class<Actor>(DynamicLoadObject(AvailableQuests[i].QuestReward, class'Class'));
  	if ( RewardClass != None )
  		Reward = Spawn(RewardClass,,,AvailableQuests[i].RewardLocation);
       if (Reward != None)
       {
  	if (AvailableQuests[i].RewardProp1 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp1, AvailableQuests[i].PropValue1);
	if (AvailableQuests[i].RewardProp2 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp2, AvailableQuests[i].PropValue2);
	if (AvailableQuests[i].RewardProp3 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp3, AvailableQuests[i].PropValue3);
	if (AvailableQuests[i].RewardProp4 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp4, AvailableQuests[i].PropValue4);
       }
  }
  //if we give it to the player
  else if (AvailableQuests[i].bGiveRewardToPlayer)
  {
   	RewardClass = class<Actor>(DynamicLoadObject(AvailableQuests[i].QuestReward, class'Class'));
	if ( RewardClass != None )
        {
		Reward = Spawn(RewardClass,Player,,Player.Location + (Player.CollisionRadius+Reward.Default.CollisionRadius+30) * Vector(Player.Rotation) + vect(0,0,1) * 15);
       if (Reward != None) //set any special properties on the reward
       {
  	if (AvailableQuests[i].RewardProp1 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp1, AvailableQuests[i].PropValue1);
	if (AvailableQuests[i].RewardProp2 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp2, AvailableQuests[i].PropValue2);
	if (AvailableQuests[i].RewardProp3 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp3, AvailableQuests[i].PropValue3);
	if (AvailableQuests[i].RewardProp4 != "")
          Reward.SetPropertyText(AvailableQuests[i].RewardProp4, AvailableQuests[i].PropValue4);
        //Find a slot for this...
       if (Reward.IsA('Inventory'))
       {
        if (Player.FindInventorySlot(Inventory(Reward), True) == True)
         Reward.Frob(Player, Player.InHand);
        else if (Player.FindInventorySlot(Inventory(Reward), True) == False)
        {
         Player.ClientMessage(NoRewardMessage);
        }
       }
       }
        }
  }
 } 

  //trigger the event
  if( AvailableQuests[i].CompletedEvent != '' )
		foreach AllActors( class 'Actor', A, AvailableQuests[i].CompletedEvent )
			A.Trigger( Self, Instigator );
  //broadcast our message if we have any
  if (AvailableQuests[i].BroadcastUponCompletion)
   BroadcastMessage(AvailableQuests[i].CompletedMessageToBroadcast);
   
 //player handling
 AddCompletedPlayer(i, Player.PlayerReplicationInfo.PlayerName);

 //message the player letting them know they pwn
 if (!AvailableQuests[i].bCompleteMessageOnHUD) //Scenario A. Client Message
 {
  Player.ClientMessage(AvailableQuests[i].CompleteQuestMessage);
 }
 else if (AvailableQuests[i].bCompleteMessageOnHUD) //or B. HUD Message
 {
  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 7.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(AvailableQuests[i].QuestName$":|n"$AvailableQuests[i].CompleteQuestMessage);
    HUD.StartMessage();
  }
 } 
  //disable the quest if need be
  if (AvailableQuests[i].bDisableQuestAfterCompletion)
   AvailableQuests[i].bQuestAvailable = False;
  if (AvailableQuests[i].bEnablesNewQuest)
   AvailableQuests[AvailableQuests[i].QuestToEnable].bQuestAvailable = True;

  //replace any actors if we are supposed to EDIT: MAJOR BUG FIX, MY COMP CRASHED OVER THIS!

      for (CurReplaceNum=0; CurReplaceNum<ArrayCount(AvailableQuests[i].ReplacementClassNames); CurReplaceNum++)
      { //second bug fix, because apparantly this doesn't stop it from producing the same thing over and over again.
	if ((AvailableQuests[i].ClassesToReplace[CurReplaceNum] != None) && (AvailableQuests[i].ReplacementClassNames[CurReplaceNum] != ""))
        {

         if (Inventory(AvailableQuests[i].ClassesToReplace[CurReplaceNum]).Owner != None)
           return;
	aClass = class<Actor>(DynamicLoadObject(AvailableQuests[i].ReplacementClassNames[CurReplaceNum], class'Class'));
	if ( aClass != None )
        {
		A = Spawn(aClass,,AvailableQuests[i].ClassesToReplace[CurReplaceNum].tag,AvailableQuests[i].ClassesToReplace[CurReplaceNum].Location, AvailableQuests[i].ClassesToReplace[CurReplaceNum].Rotation);
	     if ( A != None )
	     {
	      A.event = AvailableQuests[i].ClassesToReplace[CurReplaceNum].event;
	      A.tag = AvailableQuests[i].ClassesToReplace[CurReplaceNum].tag;
	      AvailableQuests[i].ClassesToReplace[CurReplaceNum].Destroy();
	      if (AvailableQuests[i].bTrackReplacedClasses)
              {
               AvailableQuests[AvailableQuests[i].QuestTrackingReplaced].ReplacementClassNames[CurReplaceNum] = AvailableQuests[i].NewReplacementClasses[CurReplaceNum];
               AvailableQuests[AvailableQuests[i].QuestTrackingReplaced].ClassesToReplace[CurReplaceNum] = A;
              }
              if (AvailableQuests[i].bDisableQuestAfterCompletion)
               AvailableQuests[i].ClassesToReplace[CurReplaceNum] = None;
               AvailableQuests[i].ReplacementClassNames[CurReplaceNum] = "";
             }
         }
         else
          log("ERROR: Failed to Spawn Class named "$aClass$"!");
        }
      }
 }
 else
  log("ERROR:Cannot Find Quest Named "$CompletedQuest$"!");
}

function AddCompletedPlayer(int i, string PlayerName)
{
 local int j;

      for (j=0; j<ArrayCount(AvailableQuests[i].PlayerCompletedNames); j++)
      {
	if (AvailableQuests[i].PlayerCompletedNames[j] ~= "")
        {
         AvailableQuests[i].PlayerCompletedNames[j] = PlayerName;
         return;
        }
      }
}


function bool HasCompletedPlayer(int i, string PlayerName)
{
 local int j;

      for (j=0; j<ArrayCount(AvailableQuests[i].PlayerCompletedNames); j++)
      {
	if (AvailableQuests[i].PlayerCompletedNames[j] ~= PlayerName)
         return true;
      }
 return false;
}

function AttemptCompleteQuest(string CompletedQuest, MSMTLPlayer Player)
{
 local int i;

 i = GetQuestNum(CompletedQuest);

if ((!HasCompletedPlayer(AvailableQuests[i].CompletedQuestNeeded, Player.PlayerReplicationInfo.PlayerName)) && (AvailableQuests[i].bNeedCompletedQuest))
 {
  Player.ClientMessage(NotAvailableMessage);
  return;
  //log("failed to give player quest");
 }
 if (HasCompletedPlayer(i, Player.PlayerReplicationInfo.PlayerName))
 {
  Player.ClientMessage(AlreadyCompletedMessage);
  return;
  //log("failed to give player quest");
 }
 if (!AvailableQuests[i].bQuestAvailable)
 {
  Player.ClientMessage(QuestDisabledMessage);
  return;
 }
 if (AvailableQuests[i].bQuestAvailable)
 {
 //if we've completed all the quests and we've yet to do this one...
 if (!HasCompletedPlayer(i, Player.PlayerReplicationInfo.PlayerName)) 
 {
 if ((HasCompletedPlayer(AvailableQuests[i].CompletedQuestNeeded, Player.PlayerReplicationInfo.PlayerName)) || (!AvailableQuests[i].bNeedCompletedQuest))
  {
   if (Player.PlayerReplicationInfo.Team == TeamsNeededForQuests[i])
   {
   CompleteQuest(CompletedQuest, Player);
   //log("Quest succesfully completed!");
   return;
   }
  }
 }
 }
}

function AttemptGiveQuest(string NewQuest, MSMTLPlayer Player)
{
 local int i;

 i = GetQuestNum(NewQuest);
 
if (AvailableQuests[i].bQuestAvailable)
{
 //if we've completed all the quests and we've yet to do this one...
 if (!HasCompletedPlayer(i, Player.PlayerReplicationInfo.PlayerName)) 
 {
 if ((HasCompletedPlayer(AvailableQuests[i].CompletedQuestNeeded, Player.PlayerReplicationInfo.PlayerName)) || (!AvailableQuests[i].bNeedCompletedQuest))
  {
   if (Player.PlayerReplicationInfo.Team == TeamsNeededForQuests[i])
   {
  GiveQuest(NewQuest, Player);
  //log("Gave player quest");
   }
  }
 }
}
 if ((!HasCompletedPlayer(AvailableQuests[i].CompletedQuestNeeded, Player.PlayerReplicationInfo.PlayerName)) && (AvailableQuests[i].bNeedCompletedQuest))
 {
  Player.ClientMessage(NotAvailableMessage);
  //log("failed to give player quest");
 }
 if (HasCompletedPlayer(i, Player.PlayerReplicationInfo.PlayerName))
 {
  Player.ClientMessage(AlreadyCompletedMessage);
  //log("failed to give player quest");
 }
 if (!AvailableQuests[i].bQuestAvailable)
 {
  Player.ClientMessage(QuestDisabledMessage);
  return;
 }

}

function GiveQuest(string NewQuest, MSMTLPlayer Player)
{
local int i;
local HUDMissionStartTextDisplay HUD;

i = GetQuestNum(NewQuest);

 if (!AvailableQuests[i].bGiveMessageOnHUD) //Scenario A. Client Message
 {
  Player.ClientMessage(AvailableQuests[i].GiveQuestMessage);
  //log("Gave Quest To "$Player.playerreplicationinfo.playername$" in form of client message!");
 }

 else if (AvailableQuests[i].bGiveMessageOnHUD) //or B. HUD Message
 {
  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 7.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(NewQuest$":|n"$AvailableQuests[i].GiveQuestMessage);
    HUD.StartMessage();
  }
 } 
}



defaultproperties
{
 NoRewardMessage="|cf88You don't have enough room in your inventory for the quest reward!"
 NotAvailableMessage="|p2You Haven't Unlocked This Quest Yet!"
 AlreadyCompletedMessage="|p4You've Already Completed This Quest!"
 QuestDisabledMessage="|cf88This Quest Is Currently Disabled."
}
